<?php
session_start();
if (!isset($_SESSION['user'])) {
    header("Location: login.php");
}

include 'include/head.php';
include 'include/navigation.php';
?>

    <!-- Page Content -->
    <div id="page-wrapper">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <h1 class="page-header">Bienvenue <?php echo htmlspecialchars($_SESSION['user']) ?></h1>
                </div>
                <!-- /.col-lg-12 -->
            </div>
            <!-- /.row -->
            <div class="row">
                <div class="col-lg-12">
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            Liste des cours, leurs professeurs et leurs groupes
                        </div>
                        <!-- /.panel-heading -->
                        <div class="panel-body">
                            <div class="dataTable_wrapper">
                                <table class="table table-striped table-bordered table-hover" id="dataTables-example">
                                    <thead>
                                    <tr>
                                        <th>Cours</th>
                                        <th>Groupe</th>
                                        <th>Professeur(s)</th>
                                        <th>Coefficients</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                    if ($_SESSION['role'] == 'prof') {
                                        $result = $bdd->prepare("SELECT cours.id_cours, nom_cours, id_groupe2 FROM cours, professeur, enseigne_le_cours WHERE cours.id_cours=enseigne_le_cours.id_cours AND enseigne_le_cours.id_professeur=professeur.id_professeur AND professeur.id_professeur=:id");
                                        $result->bindParam(':id', $_SESSION['id_prof']);
                                    } else {
                                        $result = $bdd->query("SELECT id_cours, nom_cours, id_groupe2 FROM cours");
                                    }
                                    $result->execute();
                                    while ($ligne = $result->fetch())
                                    {
                                        $requete = $bdd->prepare("SELECT nom FROM groupe WHERE id=:id");
                                        $requete->bindParam(':id', $ligne['id_groupe2']);
                                        $requete->execute();
                                        if ($requete->rowCount() > 0) {
                                            while ($nom = $requete->fetch())
                                            {
                                                $requete2 = $bdd->prepare("SELECT id_professeur FROM enseigne_le_cours WHERE id_cours=:id");
                                                $requete2->bindParam(':id', $ligne['id_cours']);
                                                $requete2->execute();

                                                $requete4 = $bdd->prepare("SELECT id_note_cours, type_note, coefficient FROM coefficient WHERE id_cours3=:id");
                                                $requete4->bindParam(':id', $ligne['id_cours']);
                                                $requete4->execute();

?>
                                                <tr class="odd">
                                                    <td><a href="edition-cours.php?id=<?php echo htmlspecialchars($ligne['id_cours']) ?>"><?php echo htmlspecialchars($ligne['nom_cours']) ?></a></td>
                                                <td><?php echo htmlspecialchars($nom['nom']) ?></td>
                                                <td>
<?php
                                                while ($id_prof = $requete2->fetch())
                                                {
                                                    $requete3 = $bdd->prepare("SELECT id_professeur, nom_professeur, prenom_professeur FROM professeur WHERE id_professeur=:id");
                                                    $requete3->bindParam(':id', $id_prof['id_professeur']);
                                                    $requete3->execute();
                                                    $row = $requete3->fetch();
                                                    echo htmlspecialchars($row['prenom_professeur'].' '.$row['nom_professeur']).'<br />';
                                                }
                                                ?> </td> <td>
                                                <?php
                                                while ($coeff = $requete4->fetch())
                                                {
                                                    echo '<a href="nouvelle-note.php?cours_id='.htmlspecialchars($ligne['id_cours']).'&note_id='.htmlspecialchars($coeff['id_note_cours']).'">'.htmlspecialchars($coeff['type_note'].' : '.$coeff['coefficient']).'</a>';
                                                    echo '<br />';
                                                }
                                                ?> </td> <?php
                                            }
                                        }
                                        else {
                                            ?>
                                                <td>Aucun groupe</td>
                                                <td>Aucun groupe</td>
                                                <td>Aucun groupe</td>
                                            <?php
                                        }
                                            ?>
                                        </tr>
                                        <?php
                                    }
                                    ?>
                                    </tbody>
                                </table>
                            </div>
                            <!-- /.table-responsive -->
                        </div>
                        <!-- /.panel-body -->
                    </div>
                    <!-- /.panel -->
                </div>
                <!-- /.col-lg-12 -->
            </div>
        </div>
        <!-- /.container-fluid -->
    </div>
    <!-- /#page-wrapper -->

<?php
include 'include/foot.php';
